(DEFUN DEG (Z) (* (/ Z PI) 180.0))
(DEFUN K_->OBJ_NAME (NAME)
  (COND	((= (TYPE NAME) (QUOTE ENAME))
	 (vlax-ename->vla-object NAME)
	)
	((= (TYPE NAME) (QUOTE VLA-OBJECT)) NAME)
	((= (TYPE NAME) (QUOTE STR))
	 (vlax-ename->vla-object (HANDENT NAME))
	)
	((= (TYPE NAME) (QUOTE LIST))
	 (vlax-ename->vla-object (CDR (ASSOC -1 NAME)))
	)
  )
)
(DEFUN K_AC-DOC	nil
  (vla-get-ActiveDocument (vlax-get-acad-object))
)
(DEFUN K_GET_MERKLISTE (NAME / WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ WERT (NTH 1 (ASSOC NAME K_MERKLISTE)))
  )
  WERT
)
(DEFUN K_OFANG (MODUS)
  (COND	((AND (= MODUS "aus") (= (LOGAND (GETVAR "osmode") 16384) 0))
	 (SETVAR "osmode" (+ (GETVAR "osmode") 16384))
	)
	((AND (= MODUS "ein")
	      (= (LOGAND (GETVAR "osmode") 16384) 16384)
	 )
	 (SETVAR "osmode" (- (GETVAR "osmode") 16384))
	)
	((= (TYPE MODUS) (QUOTE INT))
	 (IF (MINUSP MODUS)
	   (SETVAR "osmode"
		   (K_GET_MERKLISTE (STRCAT "osmode" (ITOA (ABS MODUS))))
	   )
	   (K_PUT_MERKLISTE
	     (STRCAT "osmode" (ITOA MODUS))
	     (GETVAR "osmode")
	   )
	 )
	)
	((= MODUS "mem")
	 (K_PUT_MERKLISTE "osmode" (GETVAR "osmode"))
	)
	((AND (= MODUS "restore") (K_GET_MERKLISTE "osmode"))
	 (SETVAR "osmode" (K_GET_MERKLISTE "osmode"))
	)
  )
)
(DEFUN K_PUT_MERKLISTE (NAME WERT)
  (IF (ASSOC NAME K_MERKLISTE)
    (SETQ K_MERKLISTE
	   (SUBST (LIST NAME WERT)
		  (ASSOC NAME K_MERKLISTE)
		  K_MERKLISTE
	   )
    )
    (SETQ K_MERKLISTE (CONS (LIST NAME WERT) K_MERKLISTE))
  )
  (PRINC)
)
(DEFUN RAD (Z) (* (/ Z 180.0) PI))

(defun c:k_ml-chamfer (/ ANZAHL	BREITE ENT_DATA	ENT_LIST ENT_LIST2 ENT_NAME MLINE_DATA MLINE_DATA2 MLINE_NAME MLINE_NAME2 N P PIC1 PIC2	PLINE_SATZ PX P_LIST
		       SATZ SATZ2)
;;; Multilinien fasen

  (defun k_ml-chamfer_pic (/ pic)
    (while (null pic)
      (print)
      (initget "a w")
      (cond
	((= (getvar "chammode") 0)
	 (setq
	   pic
	    (nentsel
	      (strcat
		"Objekt whlen oder [<Abstand>/Winkel] fr Fase <"
		(rtos (getvar "chamfera"))
		","
		(rtos (getvar "chamferb"))
		"> : "
	      )
	    )
	 )
	)
	((= (getvar "chammode") 1)
	 (setq
	   pic
	    (nentsel
	      (strcat
		"Objekt whlen oder [Abstand/<Winkel>] fr Fase <"
		(rtos (getvar "chamferc"))
		",<"
		(rtos (deg (getvar "chamferd")))
		"> : "
	      )
	    )
	 )
	)
      )
      (cond
	((= pic "a")
	 (setvar "chamfera" (getdist "Abstand 1 : "))
	 (setvar "chamferb" (getdist "Abstand 2 : "))
	 (setvar "chammode" 0)
	 (setq pic nil)
	)
	((= pic "w")
	 (setvar "chamferc"
		 (getdist "Abstand von der ersten Linie : ")
	 )
	 (setvar "chamferd" (rad (getreal "Winkel : ")))
	 (setvar "chammode" 1)
	 (setq pic nil)
	)
      )
      (cond
	((and (= (getvar "chammode") 0)
	      (equal (getvar "chamfera") 0)
	      (equal (getvar "chamferb") 0)
	 )
	 (alert "Noch keine korrekten Abstnde eingegeben")
	 (setq pic nil)
	)
	((and (= (getvar "chammode") 1)
	      (equal (getvar "chamferc") 0)
	      (equal (getvar "chamferd") 0)
	 )
	 (alert "Noch keine korrekten Abstnde eingegeben")
	 (setq pic nil)
	)
      )
    )
    pic
  )

  (defun k_ml-chamfer_mk_mline ()
    (setq anzahl     (sslength satz)
	  n	     0
	  pline_satz (ssadd)
    )
    (repeat anzahl
      (setq ent_name (ssname satz n))
      (if ent_name
	(progn
	  (setq ent_data (entget ent_name))
	  (cond
	    ((= (cdr (assoc 0 ent_data)) "LINE")
	     (setq p	    (cons 10
				  (mapcar '*
					  (cdr (assoc 10 ent_data))
					  (list 1.0 1.0 0.0)
				  )
			    )
		   ent_data
			    (subst p (assoc 10 ent_data) ent_data)
		   p	    (cons 11
				  (mapcar '*
					  (cdr (assoc 11 ent_data))
					  (list 1.0 1.0 0.0)
				  )
			    )
		   ent_data
			    (subst p (assoc 11 ent_data) ent_data)
	     )
	    )
	  )
	  (entmod ent_data)
	  (command "pedit" ent_name "j" "br" breite "x")
	  (setq pline_satz (ssadd (entlast) pline_satz))
	)				;end progn
      )					;end if
      (setq n (1+ n))
    )					;end repeat
    (setq anzahl (sslength pline_satz)
	  n	 0
    )
    (repeat anzahl
      (if pline_satz
	(progn
	  (setq ent_name (ssname pline_satz n))
	  (command "_pedit" ent_name "v" pline_satz "")
	  (while (/= (getvar "cmdactive") 0)
	    (command "x")
	  )
	  (setq pline_satz (ssget "_p"))
	  (if pline_satz
	    (if	(= anzahl (sslength pline_satz))
	      (setq n (1+ n))
	      (setq n 0)
	    )
	  )				;end if
	)
      )					;end if
    )					;end repeat
    (setq satz (ssget "l"))
    (repeat (sslength satz)
      (princ "\r")
      (princ n)
      (princ "  ")
      (setq ent_data (entget (setq ent_name (ssname satz n)))
	    p_list   (list)
      )
      (foreach dat ent_data
	(if (= (car dat) 10)
	  (setq p_list (cons (cdr dat) p_list))
	)
      )
      (setq p_list (reverse p_list))
      (command "_mline")
      (foreach p p_list
	(command p)
      )
      (if (= (rem (cdr (assoc 70 ent_data)) 2) 1)
	(command "s")
      )
      (while (= (getvar "cmdactive") 1) (command ""))
      (entdel ent_name)
      (setq n (1- n))
    )
  )

  (vla-startundomark (k_ac-doc))
  (k_ofang "mem")
  (k_ofang "aus")
  (setq pic1 (k_ml-chamfer_pic))
  (if pic1
    (progn
      (setq mline_name (nth 0 pic1)
	    mline_data (entget mline_name)
      )
      (if (= (cdr (assoc 0 mline_data)) "MLINE")
	(progn
	  (setvar "cmlstyle" (cdr (assoc 2 mline_data)))
	  (setq	px
		   (nth 1 pic1)
		p
		   (cdr (assoc 10 mline_data))
	  )
	  (foreach data	mline_data
	    (if	(and (= (car data) 11)
		     (< (distance (cdr data) px) (distance p px))
		)
	      (setq p (cdr data))
	    )
	  )
	  (setvar "clayer" (cdr (assoc 8 mline_data)))
	  (setq p_list (list))
	  (foreach dat mline_data
	    (if	(= (car dat) 11)
	      (setq p_list (cons (cdr dat) p_list))
	    )
	  )
	  (setq p_list (reverse p_list))
	  (command "_pline")
	  (foreach p p_list
	    (command p)
	  )
	  (if (= (cdr (assoc 71 mline_data)) 3)
	    (command "s")
	  )
	  (while (= (getvar "cmdactive") 1) (command ""))
	  (command "_explode" (entlast))
	  (setq	satz	 (ssget "_p")
		n	 (1- (sslength satz))
		ent_list (list)
	  )
	  (repeat (sslength satz)
	    (setq ent_name (ssname satz n)
		  ent_data (entget ent_name)
	    )
	    (if	(equal (cdr (assoc 10 ent_data)) p)
	      (setq ent_list (cons ent_name ent_list))
	    )
	    (if	(equal (cdr (assoc 11 ent_data)) p)
	      (setq ent_list (cons ent_name ent_list))
	    )
	    (setq n (1- n))
	  )
	  (setq	ent_list (vl-sort ent_list
				  '(lambda (e1 e2)
				     (<	(distance (VLAX-CURVE-GETCLOSESTPOINTTO (k_->obj_name e1) px)
						  px
					)
					(distance (VLAX-CURVE-GETCLOSESTPOINTTO (k_->obj_name e2) px)
						  px
					)
				     )
				   )
			 )
	  )
	  (if (= (length ent_list) 1)
	    (progn
	      (setq pic2 (k_ml-chamfer_pic))
	      (if pic2
		(progn
		  (setq	mline_name2 (nth 0 pic2)
			mline_data2 (entget mline_name2)
		  )
		  (if (= (cdr (assoc 0 mline_data2)) "MLINE")
		    (progn
		      (setvar "cmlstyle" (cdr (assoc 2 mline_data2)))
		      (setq px (nth 1 pic2)
			    p  (cdr (assoc 10 mline_data2))
		      )
		      (foreach data mline_data2
			(if (and (= (car data) 11)
				 (< (distance (cdr data) px)
				    (distance p px)
				 )
			    )
			  (setq p (cdr data))
			)
		      )
		      (setvar "clayer" (cdr (assoc 8 mline_data2)))
		      (setq p_list (list))
		      (foreach dat mline_data2
			(if (= (car dat) 11)
			  (setq p_list (cons (cdr dat) p_list))
			)
		      )
		      (setq p_list (reverse p_list))
		      (command "_pline")
		      (foreach p p_list
			(command p)
		      )
		      (if (= (cdr (assoc 71 mline_data2)) 3)
			(command "s")
		      )
		      (while (= (getvar "cmdactive") 1) (command ""))
		      (command "_explode" (entlast))
		      (setq satz2     (ssget "_p")
			    n	      (1- (sslength satz2))
			    ent_list2 (list)
		      )
		      (repeat (sslength satz2)
			(setq ent_name (ssname satz2 n)
			      satz     (ssadd ent_name satz)
			      ent_data (entget ent_name)
			)
			(if (equal (cdr (assoc 10 ent_data)) p)
			  (setq ent_list2 (cons ent_name ent_list2))
			)
			(if (equal (cdr (assoc 11 ent_data)) p)
			  (setq ent_list2 (cons ent_name ent_list2))
			)
			(setq n (1- n))
		      )
		      (entdel mline_name)
		      (entdel mline_name2)
		      (command "_chamfer"
			       (nth 0 ent_list)
			       (nth 0 ent_list2)
		      )
		      (setq satz (ssadd (entlast) satz))
		      (k_ml-chamfer_mk_mline)
		    )
		  )
		)
	      )
	    )
	    (progn
	      (entdel mline_name)
	      (command "_chamfer" (nth 0 ent_list) (nth 1 ent_list))
	      (setq satz (ssadd (entlast) satz))
	      (k_ml-chamfer_mk_mline)
	    )
	  )
	)
      )
    )
  )
  (k_ofang "restore")
  (vla-endundomark (k_ac-doc))
  (princ)
)